<?php
// Get current user's employee details
$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT e.*, u.email FROM employees e 
                      JOIN users u ON e.user_id = u.id 
                      WHERE e.user_id = ?");
$stmt->execute([$user_id]);
$employee = $stmt->fetch();

if(!$employee) {
    echo "<div class='alert alert-warning'>Employee profile not found!</div>";
    exit();
}
?>

<div class="row">
    <div class="col-md-4">
        <div class="card">
            <div class="card-body text-center">
                <div class="mb-3">
                    <div class="bg-primary rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 100px; height: 100px;">
                        <span class="text-white fs-3"><?php echo strtoupper(substr($employee['full_name'], 0, 1)); ?></span>
                    </div>
                </div>
                <h4><?php echo htmlspecialchars($employee['full_name']); ?></h4>
                <p class="text-muted"><?php echo ucfirst($_SESSION['role']); ?></p>
                
                <div class="mt-4 text-start">
                    <p><i class="bi bi-envelope me-2"></i> <?php echo $employee['email']; ?></p>
                    <p><i class="bi bi-telephone me-2"></i> <?php echo $employee['contact_number']; ?></p>
                    <p><i class="bi bi-building me-2"></i> <?php echo $employee['department']; ?></p>
                    <p><i class="bi bi-calendar me-2"></i> Joined: <?php echo date('d M Y', strtotime($employee['join_date'])); ?></p>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Personal Information</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label>Full Name</label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($employee['full_name']); ?>" readonly>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>NIC/Passport</label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($employee['nic_passport']); ?>" readonly>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Contact Number</label>
                            <input type="text" class="form-control" name="contact" value="<?php echo htmlspecialchars($employee['contact_number']); ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Email</label>
                            <input type="email" class="form-control" value="<?php echo $employee['email']; ?>" readonly>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Department</label>
                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($employee['department']); ?>" readonly>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Employment Type</label>
                            <input type="text" class="form-control" value="<?php echo ucfirst($employee['employment_type']); ?>" readonly>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Salary</label>
                            <input type="text" class="form-control" value="<?php echo number_format($employee['salary'], 2); ?>" readonly>
                        </div>
                         <!-- Add this in profile.php after current salary display -->
<?php if(isset($_SESSION['role']) && ($_SESSION['role'] == 'employee' || $_SESSION['role'] == 'manager')): ?>
<div class="col-md-6 mb-3">
    <label>Allowance</label>
    <input type="text" class="form-control" value="Rs. <?php echo number_format($employee['allowance'], 2); ?>" readonly>
</div>
<div class="col-md-6 mb-3">
    <label>Total Compensation</label>
    <input type="text" class="form-control" value="Rs. <?php echo number_format($employee['salary'] + $employee['allowance'], 2); ?>" readonly>
</div>
<?php endif; ?>
                        
                        <div class="col-12">
                            <button type="submit" class="btn btn-primary">Update Profile</button>
                            <button type="button" class="btn btn-outline-secondary">Change Password</button>
                        </div>

                       
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>